// Persistence of Vision Ray Tracer Scene Description File
// File: Dragons nest.pov
// Vers: 3.1 (Superpatch needed)
// Desc: IRTC entry for "Imaginary Worlds" theme.
// Date: Jan/Feb '99
// Auth: Mick Hazelgrove


#version 3.1;

#include"textures.inc"
#include "colors.inc" 
#include "bdrag.inc"
#include "dragon2.inc"
#include "RightMWing.inc"
#include "LeftMWing.inc"
#include "DHead.inc" 
#include "DNeck.inc" 

global_settings {
assumed_gamma 1.0 
  max_trace_level 20
    ambient_light color <1,0,0>
}

// ----------------------------------------

camera
{
  location  <0.0, 250, -485>  // 
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0,  0> //
} 

light_source {<-2000, 2000, -2000> color rgb<1,0.5,0>/.75}
light_source {<2000, -100, -2000> color rgb <0.1, 0.1, 0.25>/.75}
 light_source {<2000, 2000, -2000> color rgb<0.45, 0.25, 0.0>/.75}
//-----------------------------------------

#declare Clouds_on = 1;   
#declare Clouds2_on = 1;
#declare Mist_on = 1; 
#declare Mountains_on  = 1;
#declare Dragon_on = 1;  
#declare Nest_on = 1; 
#declare Adult_head_on = 1;
//--------------------------------------------
//Clouds 

#if  (Clouds_on = 1)

#declare SKY = difference{
        sphere{0,1000}
        sphere{0,975 }
        }
#declare SKY2 = difference{
        sphere{0,970}
        sphere{0,968 }
        clipped_by{plane{z,-10}}
        rotate y *180
        }
        
object{SKY
    pigment { rgbf   1 }
   	interior {
   		media {
			intervals 10
			emission rgb<0.3,0.1,0>
			samples 2, 10
			confidence 0.9999
			variance 1/1000

                        density { 
                        	spotted density_map{
                        	    [0.0 rgb<0,0,0>]
                        		    [0.5 spotted ramp_wave frequency 10 turbulence 0.25
                        		    	colour_map {
                        		    		[0 rgb 0]
                        		    		[0.2 rgb 0.5]
                        		    		[0.4 rgb 0]
                        		    		[0.6 rgb 0]
                        		    		[0.8 rgb 0]
                        		    		[1 rgb 0]}]
                        		    [1.00 rgb<0,0,0>]   
                        		}
                                scale 90 
                        }		
		}
    }

	hollow 
	translate<0,0,0>
	scale 0.5 	
 }
 #end 
 
//---------------------------------------------------------------------------------------- 

#if (Clouds2_on = 1)
object{SKY2
    pigment { rgbf   1 }
   	interior {
   		media {
			intervals 10
			emission  rgb<1,0.0,0.0>
			samples 2, 10
			confidence 0.9999
			variance 1/1000

                        density { 
                        	spotted density_map{
                        	    [0.0 rgb<0,0,0>]
                        		    [0.5 spotted ramp_wave frequency 10 turbulence 0.5 
                        		    	colour_map {
                        		    		[0 rgb 0]
                        		    		[0.2 rgb 0.5]
                        		    		[0.4 rgb 0]
                        		    		[0.6 rgb 0]
                        		    		[0.8 rgb 0]
                        		    		[1 rgb 0]}]
                        		    [1.00 rgb<0,0,0>]   
                        		}
                                scale 100 
                        }
                     rotate y*180		
		}
    }

	hollow 
	translate<0,0,0>
	scale 0.5 	
 }
 
 #end
 
//------------------------------------------------------------------------------------------
//Mist

#if (Mist_on = 1)

cylinder{-120*y,-100*y,1000
    pigment { rgbf 1 }
   	interior {
   		media {
			intervals 30
			emission <0.3,0.0,0.1> 
			samples 2, 10
			confidence 0.9999
			variance 1/1000

                        density { 
                        	bozo density_map{
                        	    [0.0 rgb<0,0,0>]
                        		    [0.5 bozo ramp_wave frequency 3 
                        		    	colour_map {
                        		    		[0 rgb 0]
                        		    		[0.1 rgb <0.5,0,0>]
                        		    		[0.2 rgb <0.5,0,0.5>]
                        		    		[0.3 rgb <0.5,0.5,0>] 
                        		    		[0.4 rgb 0]
                        		    		[0.6 rgb 0]
                        		    		[0.8 rgb 0]
                        		    		[1 rgb 0]}]
                        		    [1.00 rgb<0,0,0>]   
                        		}
                                scale 90
                        }
                        scale 0.5		
		}
    }

	hollow 
	translate<0,-100,0>
	scale 0.5
	finish{specular 1}	
}

#end 

//------------------------------------------------


//-------------------------------------------------- 
/***Terrain***/ 

#if (Mountains_on = 1)
 
#declare TerrainTexture =
texture{
  pigment {
    gradient x
    turbulence 0.30
    omega 2
    color_map {
      [0.00 color rgb<0.175, 0.0, 0.7>]
      [0.233 color rgb<0.125, 0.0, 0.5>]
      [0.66 color rgb<0.15, 0.0, 0.6>]
      [1.00 color rgb<0.175, 0.0, 0.7>]
    }
    rotate x*90
    scale 0.5
  }
  normal{bump_map{gif "c:LSBMblur2"
			bump_size 1.000000
			interpolate 2
		}
		rotate <90, 0, 0>
		scale 0.25 
		turbulence 0.015
	}
}

height_field
{
	tga "c:terrai_t2.tga"
	smooth

	texture { TerrainTexture }
	finish{specular 0.15 ambient 0.4 crand 0.50}
	translate <-0.5, 0.0, -0.5>
	scale <1000, 150, 1000>
	rotate <0.0, 12, 0.0>
	translate <0, -120,0>
}
 
height_field
{
	tga "c:terrai_t2.tga"
	smooth

	texture { TerrainTexture }
	finish{specular 0.15 ambient 0.4 crand 0.50}
	translate <-0.5, 0.0, -0.5>
	scale <275, 55, 270>
	rotate <0.0, 180, 0.0>
	translate <0, -120.5,0>
}
#end 
//--------------------------------------------------------------
#if (Dragon_on = 1)

#declare DTex = texture{
         pigment {wrinkles color_map {
            [0 rgb <0, 0, 1>]
             [0.5 rgb <0, 1, .5>]
            [1 rgb <0, 1, 1>]}
            scale 12}
scale 0.5 
rotate x*-90
normal{agate 0.35 scale 10}
finish {phong 0.5 phong_size 5}
}

#declare Eye = 

sphere{0,1 
        texture{
          pigment {
            radial
            //turbulence 0.70
            color_map {
               [0.45 color rgb<1, 0, 0>]
               [0.475 color rgb<0, 0, 0>]
               [0.525 color rgb<0, 0, 0>]
               [0.55 color rgb<1, 0, 0>]
            }
          }
          finish {specular 3 roughness 0.01}
          rotate y*-90
}
}
//-----------------------------------------

#declare Dragon = union{
object{dragon2 
matrix <1,0,0, 0,0,1, 0,1,0, 0,0,0> //swop to pov co-ordinate system
  scale<1.1,1,.75> 
    texture{DTex}
        rotate y*-90 
            translate<20,0,0>
}
object{RWing texture{DTex scale 0.1}
        scale 15
            rotate z*25
                translate<20,50,-90> 
}
object{LWing texture{DTex scale 0.1}
        scale 15
            rotate z*-25
                translate <-20,50,-90>  
}
object{Eye scale 10 translate <26,127.5,-235>}
object{Eye scale 10 rotate y*180 translate <-16,127.5,-235>}
}

#declare Dragon2 = union{
object{dragon2 
matrix <1,0,0, 0,0,1, 0,1,0, 0,0,0> //swop to pov co-ordinate system
  scale<1.1,1,.75> 
    texture{DTex}
        rotate y*-90 
            translate<20,0,0>
}
object{RWing texture{DTex scale 0.1}
        scale 15
            rotate z*-45
                translate<20,60,-90> 
}
object{LWing texture{DTex scale 0.1}
        scale 15
            rotate z*45
                translate <-20,60,-90>  
}
object{Eye scale 10 translate <26,127.5,-235>}
object{Eye scale 10 rotate y*180 translate <-16,127.5,-235>}
}

object{Dragon  // lower right
rotate z*27.5 
rotate y*40
rotate x*-20
scale .05
translate<25,187.5,-410> //*****just changed this one
}

object{Dragon  //new one interesting at scale .75 trans 85,110,-200 right middle
rotate z*27.5 
rotate y*-5
scale .1
translate<90,110,-200> 
}
 
object{Dragon2  //right wings down
rotate y*-10
rotate z*25
scale .125
translate<100,140,-100>
}

object{Dragon  //far left low
rotate y*-165
rotate z*-25
scale .175
translate<-130,40,-100> 
}

object{Dragon //top left left
rotate y*-110
rotate x*-25
scale .125
translate<-80,50,100>//was -60 
}

#end 

#if (Nest_on = 1)
#declare RS = seed(6666);


#declare NFUC = function {(sin(x)+(cos(y)+2)*cos(z))*1.5}

#declare Nest = union{
sphere{0,1 clipped_by{plane{y,0.35}}
        pigment{rgb<.15,0.25,1>}
        normal{function NFUC  scallop_wave scale 0.1 rotate z*45}
        finish{specular 1 reflection 0.15}
        scale <1,0.8,1>
        }
torus{1,0.025 
        pigment{rgb<.15,0.25,1>}
        normal {radial 3 scallop_wave frequency 66 rotate z*45}
        finish{specular 1 reflection 0.15}
        scale 1.025
        translate y*0.075        
        }
        
torus{1,0.025 
        pigment{rgb<.15,0.25,1>}
        normal {radial 3 scallop_wave frequency 66 rotate z*45}
        finish{specular 1 reflection 0.15}
        translate y*-0.15        
        }             
}
       

#declare Nests = union{
object{Nest scale 10+rand(RS*10)translate<-10,25,0>}
object{Nest scale 10+rand(RS*10)translate<-40,7,0>}
object{Nest scale 10+rand(RS*10)translate<-20,10,20>}
object{Nest scale 10+rand(RS*10)translate<10,5,30>}
object{Nest scale 10+rand(RS*10)translate<5,5,10>}
object{Nest scale 10+rand(RS*10)translate<20,20,-10>}
object{Nest scale 10+rand(RS*10)translate<40,4,0>}
object{Nest scale 10+rand(RS*10)translate<20,5,-30>}
object{Nest scale 10+rand(RS*10)translate<0,3,-20>}
object{Nest scale 10+rand(RS*10)translate<-20,6,-20>}
object{Nest scale 10+rand(RS*10)translate<-5,5,-55>} 
}




#declare Egg = union{

sphere{0,0.6 clipped_by {plane{y,0}}}

sphere{0,0.6 scale <1,1.75,1>  clipped_by {plane{y,0 inverse}}}

}

#declare Eggs = union{
//object{Egg scale 14+rand(RS*10)translate<-10,25,0>}
object{Egg scale 10+rand(RS*10)translate<-40,7,0>}
object{Egg scale 10+rand(RS*10)translate<-20,10,20>}
object{Egg scale 10+rand(RS*10)translate<10,5,30>}
object{Egg scale 10+rand(RS*10)translate<5,5,10>}
object{Egg scale 10+rand(RS*10)translate<20,20,-10>}
object{Egg scale 10+rand(RS*10)translate<40,4,0>}
object{Egg scale 10+rand(RS*10)translate<20,5,-30>}
object{Egg scale 10+rand(RS*10)translate<0,3,-20>}
object{Egg scale 10+rand(RS*10)translate<-20,6,-20>}
object{Egg scale 10+rand(RS*10)translate<-5,5,-55>} 
}

//------------------------------------------------------

#macro Flame(Turb,Freq,Lam,Sc) 
 sphere {0, 1
     pigment { color rgbf<1, 1, 1, 1> }
      interior{
         media{
         emission .03
         intervals 5
         samples 15, 20
         confidence 0.999
         variance 1/1000
            density {
                 spherical
                 ramp_wave
                 color_map {
                         [0.0 color rgb <0.0, 0.0, 0.0>]
                         [0.25 color rgb <0.0, 1, 0.0>]
                         [0.95 color rgb <0.0, 0.0, 1>]
                         [1.0 color rgb <0.5, 0.5, 0.0>]
                 }

                turbulence Turb
                frequency Freq
                lambda Lam
                scale <.25,.5,.25>
            }

         }
      }
     hollow
     scale Sc
}
#end
      
#declare Flames = union{
object{Flame(.7,2,5,2) rotate y*10 scale 12+rand(RS*10)translate<-10,25+2,0>}
object{Flame(.5,3,3,3) rotate y*30 scale 10+rand(RS*10)translate<-40,7+2,0>}
object{Flame(.6,4,9,2) rotate y*50 scale 10+rand(RS*10)translate<-20,10+2,20>}
object{Flame(.7,1,0,2.5) rotate y*70 scale 10+rand(RS*10)translate<10,5+2,30>}
object{Flame(.4,3,20,2) rotate y*30 scale 10+rand(RS*10)translate<5,5+2,10>}
object{Flame(.3,5,15,3.3) rotate y*60 scale 10+rand(RS*10)translate<20,20+2,-10>}
object{Flame(.2,2,5,2.2) rotate y*150 scale 10+rand(RS*10)translate<40,4+2,0>}
object{Flame(.5,3,3,2.5) rotate y*10 scale 10+rand(RS*10)translate<20,5+2,-30>}
object{Flame(.6,6,7,2) rotate y*20 scale 10+rand(RS*10)translate<0,3+3,-20>}
object{Flame(.7,2,2,2.75) rotate y*40 scale 10+rand(RS*10)translate<-20,6+2,-20>}
object{Flame(.5,3,3,3) rotate y*60 scale 10+rand(RS*10)translate<-5,5+2,-55>} 
}
  
//-----------------Put it together----------------------
#declare Birthplace = union{
object{Nests scale 2 }
object{Flames scale 2 }
object{Eggs pigment{White}scale 1.9 }
no_shadow
}

object{Birthplace translate y*-90}        

       
//--------------------------------------------------------
#declare HEgg = sphere{0,1 scale <0.7,1,0.7>}
#declare HEgg2 = sphere{0,0.975 scale <0.7,1,0.7>}

#declare Break = prism {
  conic_sweep 
    linear_spline 
       0, 8, 21,          
        <0 ,5>,<1, 2>,<2, 3>,<2, 1>,<4, 2>,<2, 0>,<4, -1>,< 2,-1>,<3, -3>,
        <1, -2>,<0, -4>,<-1, -2>,<-3, -3>,<-2, -1>,<-4, 0>,<-3, 1>,<-4, 2>,
        <-3, 2>,<-3, 3>,<-1,2>,<0, 5>
  scale <0.3,2,0.5>
  scale <3,2,3> 
  rotate y*45
  rotate x*-20 
}



#declare Hatched_Egg = difference{
  object{HEgg}
     object{HEgg2}
       object{Break}                          
}

object{Hatched_Egg pigment{White}scale 25 
translate<-20,-35,0>
} 
object{Hatched_Egg pigment{White}scale 19 
rotate y*90
rotate z*10 
rotate x*-10
translate<-100,-88   ,-20>
} 
object{Hatched_Egg pigment{White}scale 22.5
rotate y*180
rotate z*-10 
rotate x*-90
translate<-80,-88,-45> 
} 
object{Hatched_Egg pigment{White}scale 20 
rotate y*-45
//rotate z*85 
rotate x*-45 
translate<130,-88,0>
} 
object{Hatched_Egg pigment{White}scale 22.5
rotate y*-25
rotate z*25 
rotate x*-30 
translate<-120,-88,-70>  
}
 
//-------------------------------------------------
#declare hatchling = union{
object{babydrag 
scale 0.175
 matrix <1,0,0, 0,0,1, 0,1,0, 0,0,0> //swop to pov co-ordinate system
   translate<0,-25,10> 
    texture{DTex }
}

object{sphere{0,1 scale<1,1,0.75>scale 10 texture{DTex}translate<-20,-35,15>}}//x=z

object{RWing texture{DTex scale 0.1}    //x=y
        scale 2.5
            rotate z*50
            rotate y*90
                translate<-25,-30,10> 
}
object{LWing texture{DTex scale 0.1}
        scale 2.5
            rotate z*-25
            rotate y*90
                translate <-20,-30,20>  
}
}

object{hatchling
          rotate y*-75
          translate z*20
}
          
#end

#if (Adult_head_on = 1)

#declare DTex2 = texture{
         pigment {wrinkles color_map {
            [0 rgb <0, 0, 1>]
             [0.5 rgb <0, 1, .5>]
            [1 rgb <0, 1, 1>]}
            scale 12} 
rotate x*-90
normal{crackle 50 scale .075} //was 5 .05
}

#declare AHead = union{
        object{Head  scale 75  }
        object{ DNeck  scale 75 rotate z*-45 translate<-20,300,0> }
}

object{AHead texture{DTex2 scale 150} rotate y*-60 rotate x*-20 translate <50,10,350> 
finish { ambient 0.6 phong 0.5 phong_size 5}
}
object{AHead texture{DTex2 scale 150} rotate y*200 translate <-130,25,565> 
finish { phong 0.5 phong_size 5}
} 

 

#end
